	function Tg = PZ_2_TG_S(G, Z, P, W)
	
	% 	Computes the group delay from the poles and zeros for 
	% 	an analog transfer function at the frequencies specified by W.

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2005-11-04
	% 	Modified by: 	LW 2009-01-20
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	
	Tg = zeros(1,length(W));
	for n = 1:length(P)
		Tg = Tg - P(n)./(P(n)^2 + W.^2);		
	end
	for n = 1:length(Z)
		Tg = Tg + Z(n)./(Z(n)^2 + W.^2 + 10^-10); % Avoid to divide by zero
	end
	Tg = real(Tg);
